/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.material.item.SpigotItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeSpawnEgg;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.entity.EntityType;
import org.bukkit.material.MaterialData;
import org.bukkit.material.SpawnEgg;

public class SpigotItemTypeSpawnEgg
extends SpigotItemType
implements WSItemTypeSpawnEgg {
    private EnumEntityType entityType;

    public SpigotItemTypeSpawnEgg(EnumEntityType entityType) {
        super(383, "minecraft:spawn_egg", "minecraft:$entity_spawn_egg", 64);
        Validate.notNull((Object)entityType, "Entity type cannot be null!");
        this.entityType = entityType;
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + this.entityType.getName().toLowerCase() + "_spawn_egg";
    }

    @Override
    public EnumEntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntityType(EnumEntityType entityType) {
        Validate.notNull((Object)entityType, "Entity type cannot be null!");
        this.entityType = entityType;
    }

    @Override
    public SpigotItemTypeSpawnEgg clone() {
        return new SpigotItemTypeSpawnEgg(this.entityType);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof SpawnEgg) {
            ((SpawnEgg)data).setSpawnedType(EntityType.fromId((int)this.entityType.getTypeId()));
        }
        return data;
    }

    @Override
    public SpigotItemTypeSpawnEgg readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.entityType = EnumEntityType.getByTypeId(materialData.getData()).orElse(EnumEntityType.PIG);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotItemTypeSpawnEgg that = (SpigotItemTypeSpawnEgg)o;
        return this.entityType == that.entityType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.entityType});
    }
}

