/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.firework.SpigotFireworkEffect;
import com.degoos.wetsponge.firework.WSFireworkEffect;
import com.degoos.wetsponge.material.item.SpigotItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeFirework;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpigotItemTypeFirework
extends SpigotItemType
implements WSItemTypeFirework {
    private int power;
    private List<WSFireworkEffect> effects;

    public SpigotItemTypeFirework(int power, List<WSFireworkEffect> effects) {
        super(401, "minecraft:fireworks", "minecraft:firework_rocket", 64);
        this.power = power;
        this.effects = effects == null ? new ArrayList<WSFireworkEffect>() : new ArrayList<WSFireworkEffect>(effects);
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public List<WSFireworkEffect> getEffects() {
        return this.effects;
    }

    @Override
    public void setEffects(List<WSFireworkEffect> effects) {
        this.effects = effects == null ? new ArrayList() : effects;
    }

    @Override
    public SpigotItemTypeFirework clone() {
        return new SpigotItemTypeFirework(this.power, this.effects);
    }

    @Override
    public void writeItemMeta(ItemMeta itemMeta) {
        super.writeItemMeta(itemMeta);
        if (itemMeta instanceof FireworkMeta) {
            ((FireworkMeta)itemMeta).setPower(this.power);
            ((FireworkMeta)itemMeta).clearEffects();
            ((FireworkMeta)itemMeta).addEffects((Iterable)this.effects.stream().map(target -> ((SpigotFireworkEffect)target).getHandled()).collect(Collectors.toList()));
        }
    }

    @Override
    public void readItemMeta(ItemMeta itemMeta) {
        super.readItemMeta(itemMeta);
        if (itemMeta instanceof FireworkMeta) {
            this.power = ((FireworkMeta)itemMeta).getPower();
            this.effects = ((FireworkMeta)itemMeta).getEffects().stream().map(SpigotFireworkEffect::new).collect(Collectors.toList());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotItemTypeFirework that = (SpigotItemTypeFirework)o;
        return this.power == that.power && Objects.equals(this.effects, that.effects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.power, this.effects);
    }
}

