/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.bridge.material.item.BridgeItemTypeSkull;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSkullType;
import com.degoos.wetsponge.material.item.Spigot13ItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeSkull;
import com.degoos.wetsponge.resource.spigot.Spigot13SkullBuilder;
import com.degoos.wetsponge.user.Spigot13GameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.Validate;
import com.mojang.authlib.GameProfile;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Spigot13ItemTypeSkull
extends Spigot13ItemType
implements WSItemTypeSkull {
    private WSGameProfile profile;
    private EnumBlockTypeSkullType skullType;

    public Spigot13ItemTypeSkull(WSGameProfile profile, EnumBlockTypeSkullType skullType) {
        super(397, "minecraft:skull", "minecraft:skull", 64);
        Validate.notNull((Object)skullType, "Skull type cannot be null!");
        this.profile = profile;
        this.skullType = skullType;
    }

    @Override
    public String getNewStringId() {
        return this.skullType.getMinecraftName() + (this.skullType == EnumBlockTypeSkullType.SKELETON || this.skullType == EnumBlockTypeSkullType.WITHER_SKELETON ? "_skull" : "_head");
    }

    @Override
    public Optional<WSGameProfile> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    @Override
    public void setProfile(WSGameProfile profile) {
        this.profile = profile;
    }

    @Override
    public void setTexture(String texture) {
        BridgeItemTypeSkull.setTexture(texture, this.profile);
    }

    @Override
    public void setTexture(URL texture) {
        BridgeItemTypeSkull.setTexture(texture, this.profile);
    }

    @Override
    public void setTextureByPlayerName(String name) {
        this.profile = BridgeItemTypeSkull.setTextureByPlayerName(name);
    }

    @Override
    public void findFormatAndSetTexture(String texture) {
        if (texture.toLowerCase().startsWith("http:") || texture.toLowerCase().startsWith("https:")) {
            this.setTexture(this.getTexture(texture));
        } else if (texture.length() <= 16) {
            this.setTextureByPlayerName(texture);
        } else {
            this.setTexture(texture);
        }
    }

    @Override
    public EnumBlockTypeSkullType getSkullType() {
        return this.skullType;
    }

    @Override
    public void setSkullType(EnumBlockTypeSkullType skullType) {
        Validate.notNull((Object)skullType, "Skull type cannot be null!");
        this.skullType = skullType;
    }

    private String getTexture(String url) {
        if (url == null) {
            return null;
        }
        return String.format("{textures:{SKIN:{url:\"%s\"}}}", url);
    }

    @Override
    public Spigot13ItemTypeSkull clone() {
        return new Spigot13ItemTypeSkull(this.profile, this.skullType);
    }

    @Override
    public void writeItemMeta(ItemMeta itemMeta) {
        super.writeItemMeta(itemMeta);
        if (itemMeta instanceof SkullMeta) {
            Spigot13SkullBuilder.injectGameProfile(itemMeta, this.profile == null ? null : ((Spigot13GameProfile)this.profile).getHandled());
        }
    }

    @Override
    public void readItemMeta(ItemMeta itemMeta) {
        super.readItemMeta(itemMeta);
        if (itemMeta instanceof SkullMeta) {
            GameProfile profile = Spigot13SkullBuilder.getGameProfile(itemMeta);
            this.profile = profile == null ? null : new Spigot13GameProfile(profile);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13ItemTypeSkull that = (Spigot13ItemTypeSkull)o;
        return Objects.equals(this.profile, that.profile) && this.skullType == that.skullType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.profile, this.skullType});
    }
}

