/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.material.Spigot13Material;
import com.degoos.wetsponge.material.item.WSItemType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import java.util.Objects;
import org.bukkit.inventory.meta.ItemMeta;

public class Spigot13ItemType
implements Spigot13Material,
WSItemType {
    private int numericalId;
    private String oldStringId;
    private String newStringId;
    private int maxStackSize;

    public Spigot13ItemType(int numericalId, String oldStringId, String newStringId, int maxStackSize) {
        this.numericalId = numericalId < 0 ? -1 : numericalId;
        this.oldStringId = oldStringId == null || oldStringId.equals("") ? null : oldStringId;
        this.newStringId = newStringId;
        this.maxStackSize = Math.max(1, maxStackSize);
    }

    @Override
    public Spigot13ItemType clone() {
        return new Spigot13ItemType(this.numericalId, this.oldStringId, this.newStringId, this.maxStackSize);
    }

    @Override
    public int getNumericalId() {
        return this.numericalId;
    }

    @Override
    public String getStringId() {
        return WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13) ? this.getOldStringId() : this.getNewStringId();
    }

    @Override
    public String getNewStringId() {
        return this.newStringId;
    }

    @Override
    public String getOldStringId() {
        return this.oldStringId;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public void writeItemMeta(ItemMeta itemMeta) {
    }

    @Override
    public void readItemMeta(ItemMeta itemMeta) {
    }

    @Override
    public void writeNBTTag(WSNBTTagCompound compound) {
    }

    @Override
    public void readNBTTag(WSNBTTagCompound compound) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13ItemType that = (Spigot13ItemType)o;
        return this.numericalId == that.numericalId && this.maxStackSize == that.maxStackSize && Objects.equals(this.oldStringId, that.oldStringId) && Objects.equals(this.newStringId, that.newStringId);
    }

    public int hashCode() {
        return Objects.hash(this.numericalId, this.oldStringId, this.newStringId, this.maxStackSize);
    }
}

