/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSnow;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeSnow
extends SpongeBlockType
implements WSBlockTypeSnow {
    private int layers;
    private int minimumLayers;
    private int maximumLayers;

    public SpongeBlockTypeSnow(int layers, int minimumLayers, int maximumLayers) {
        super(78, "minecraft:snow_layer", "minecraft:snow", 64);
        this.layers = layers;
        this.minimumLayers = minimumLayers;
        this.maximumLayers = maximumLayers;
    }

    @Override
    public int getLayers() {
        return this.layers;
    }

    @Override
    public void setLayers(int layers) {
        layers = Math.max(this.minimumLayers, Math.min(this.maximumLayers, layers));
    }

    @Override
    public int getMinimumLayers() {
        return this.minimumLayers;
    }

    @Override
    public int getMaximumLayers() {
        return this.maximumLayers;
    }

    @Override
    public SpongeBlockTypeSnow clone() {
        return new SpongeBlockTypeSnow(this.layers, this.minimumLayers, this.maximumLayers);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.LAYER, (Object)this.layers);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.LAYER, (Object)this.layers).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeSnow readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.layers = valueContainer.get(Keys.LAYER).orElse(1);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeSnow that = (SpongeBlockTypeSnow)o;
        return this.layers == that.layers && this.minimumLayers == that.minimumLayers && this.maximumLayers == that.maximumLayers;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.layers, this.minimumLayers, this.maximumLayers);
    }
}

