/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.SpongeBlockTypeWaterlogged;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSeaPickle;
import java.util.Objects;

public class SpongeBlockTypeSeaPickle
extends SpongeBlockTypeWaterlogged
implements WSBlockTypeSeaPickle {
    private int pickles;
    private int minimumPickles;
    private int maximumPickles;

    public SpongeBlockTypeSeaPickle(boolean waterLogged, int pickles, int minimumPickles, int maximumPickles) {
        super(-1, null, "minecraft:sea_pickle", 64, waterLogged);
        this.pickles = pickles;
        this.minimumPickles = minimumPickles;
        this.maximumPickles = maximumPickles;
    }

    @Override
    public int getPickles() {
        return this.pickles;
    }

    @Override
    public void setPickles(int pickles) {
        this.pickles = Math.min(this.maximumPickles, Math.max(this.minimumPickles, pickles));
    }

    @Override
    public int getMinimumPickles() {
        return this.minimumPickles;
    }

    @Override
    public int getMaximumPickles() {
        return this.maximumPickles;
    }

    @Override
    public SpongeBlockTypeSeaPickle clone() {
        return new SpongeBlockTypeSeaPickle(this.isWaterlogged(), this.pickles, this.minimumPickles, this.maximumPickles);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeSeaPickle that = (SpongeBlockTypeSeaPickle)o;
        return this.pickles == that.pickles && this.minimumPickles == that.minimumPickles && this.maximumPickles == that.maximumPickles;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pickles, this.minimumPickles, this.maximumPickles);
    }
}

