/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSapling;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeSapling
extends SpongeBlockType
implements WSBlockTypeSapling {
    private EnumWoodType woodType;
    private int stage;
    private int maximumStage;

    public SpongeBlockTypeSapling(EnumWoodType woodType, int stage, int maximumStage) {
        super(6, "minecraft:sapling", "minecraft:sapling", 64);
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.woodType = woodType;
        this.stage = stage;
        this.maximumStage = maximumStage;
    }

    @Override
    public String getNewStringId() {
        switch (this.getWoodType()) {
            case SPRUCE: {
                return "minecraft:spruce_sapling";
            }
            case BIRCH: {
                return "minecraft:birch_sapling";
            }
            case JUNGLE: {
                return "minecraft:jungle_sapling";
            }
            case ACACIA: {
                return "minecraft:acacia_sapling";
            }
            case DARK_OAK: {
                return "minecraft:dark_oak_sapling";
            }
        }
        return "minecraft:oak_sapling";
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.woodType = woodType;
    }

    @Override
    public int getStage() {
        return this.stage;
    }

    @Override
    public void setStage(int stage) {
        this.stage = Math.min(this.maximumStage, Math.max(0, stage));
    }

    @Override
    public int getMaximumStage() {
        return this.maximumStage;
    }

    @Override
    public SpongeBlockTypeSapling clone() {
        return new SpongeBlockTypeSapling(this.woodType, this.stage, this.maximumStage);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.GROWTH_STAGE, (Object)this.stage);
        itemStack.offer(Keys.TREE_TYPE, Sponge.getRegistry().getType(TreeType.class, this.woodType.name()).orElseThrow(NullPointerException::new));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        blockState = blockState.with(Keys.GROWTH_STAGE, (Object)this.stage).orElse(blockState);
        return blockState.with(Keys.TREE_TYPE, Sponge.getRegistry().getType(TreeType.class, this.woodType.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeSapling readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.stage = valueContainer.get(Keys.GROWTH_STAGE).orElse(0);
        this.woodType = EnumWoodType.getByName(((TreeType)valueContainer.get(Keys.TREE_TYPE).get()).getName()).orElseThrow(NullPointerException::new);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeSapling that = (SpongeBlockTypeSapling)o;
        return this.stage == that.stage && this.maximumStage == that.maximumStage && this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.woodType, this.stage, this.maximumStage});
    }
}

