/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpongeBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeRepeater;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeRepeater
extends SpongeBlockTypeDirectional
implements WSBlockTypeRepeater {
    private int delay;
    private int minimumDelay;
    private int maximumDelay;
    private boolean locked;
    private boolean powered;

    public SpongeBlockTypeRepeater(EnumBlockFace facing, Set<EnumBlockFace> faces, int delay, int minimumDelay, int maximumDelay, boolean locked, boolean powered) {
        super(93, "minecraft:unpowered_repeater", "minecraft:repeater", 64, facing, faces);
        this.delay = delay;
        this.minimumDelay = minimumDelay;
        this.maximumDelay = maximumDelay;
        this.locked = locked;
        this.powered = powered;
    }

    @Override
    public int getNumericalId() {
        return this.powered ? 94 : 93;
    }

    @Override
    public String getOldStringId() {
        return this.powered ? "minecraft:powered_repeater" : "minecraft:unpowered_repeater";
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int delay) {
        this.delay = Math.max(this.minimumDelay, Math.min(this.minimumDelay, delay));
    }

    @Override
    public int getMinimumDelay() {
        return this.minimumDelay;
    }

    @Override
    public int getMaximumDelay() {
        return this.maximumDelay;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public SpongeBlockTypeRepeater clone() {
        return new SpongeBlockTypeRepeater(this.getFacing(), this.getFaces(), this.delay, this.minimumDelay, this.maximumDelay, this.locked, this.powered);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.DELAY, (Object)this.delay);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        blockState = (BlockState)((IBlockState)blockState).func_177226_a((IProperty)BlockRedstoneRepeater.field_176411_a, (Comparable)Boolean.valueOf(this.locked));
        return blockState.with(Keys.DELAY, (Object)this.delay).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeRepeater readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.delay = valueContainer.get(Keys.DELAY).orElse(0);
        if (valueContainer instanceof IBlockState) {
            this.locked = (Boolean)((IBlockState)valueContainer).func_177229_b((IProperty)BlockRedstoneRepeater.field_176411_a);
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeRepeater that = (SpongeBlockTypeRepeater)o;
        return this.delay == that.delay && this.minimumDelay == that.minimumDelay && this.maximumDelay == that.maximumDelay && this.locked == that.locked && this.powered == that.powered;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delay, this.minimumDelay, this.maximumDelay, this.locked, this.powered);
    }
}

