/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypePrismarineType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypePrismarine;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.PrismarineType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypePrismarine
extends SpongeBlockType
implements WSBlockTypePrismarine {
    private EnumBlockTypePrismarineType prismarineType;

    public SpongeBlockTypePrismarine(EnumBlockTypePrismarineType prismarineType) {
        super(168, "minecraft:prismarine", "minecraft:prismarine", 64);
        Validate.notNull((Object)prismarineType, "Prismarine type cannot be null!");
        this.prismarineType = prismarineType;
    }

    @Override
    public String getNewStringId() {
        switch (this.prismarineType) {
            case DARK: {
                return "minecraft:dark_prismarine";
            }
            case BRICKS: {
                return "minecraft:prismarine_bricks";
            }
        }
        return "minecraft:prismarine";
    }

    @Override
    public EnumBlockTypePrismarineType getPrismarineType() {
        return this.prismarineType;
    }

    @Override
    public void setPrismarineType(EnumBlockTypePrismarineType prismarineType) {
        Validate.notNull((Object)prismarineType, "Prismarine type cannot be null!");
        this.prismarineType = prismarineType;
    }

    @Override
    public SpongeBlockTypePrismarine clone() {
        return new SpongeBlockTypePrismarine(this.prismarineType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.PRISMARINE_TYPE, Sponge.getRegistry().getType(PrismarineType.class, this.prismarineType.name()).orElseThrow(NullPointerException::new));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.PRISMARINE_TYPE, Sponge.getRegistry().getType(PrismarineType.class, this.prismarineType.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypePrismarine readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.prismarineType = EnumBlockTypePrismarineType.getByName(((PrismarineType)valueContainer.get(Keys.PRISMARINE_TYPE).get()).getName()).orElse(EnumBlockTypePrismarineType.ROUGH);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypePrismarine that = (SpongeBlockTypePrismarine)o;
        return this.prismarineType == that.prismarineType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.prismarineType});
    }
}

