/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumAxis;
import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.SpongeBlockTypeOrientable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeLog;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.LogAxes;
import org.spongepowered.api.data.type.LogAxis;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.type.TreeTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeLog
extends SpongeBlockTypeOrientable
implements WSBlockTypeLog {
    private EnumWoodType woodType;
    private boolean stripped;
    private boolean allFacesCovered;

    public SpongeBlockTypeLog(EnumAxis axis, Set<EnumAxis> axes, EnumWoodType woodType, boolean stripped, boolean allFacesCovered) {
        super(17, "minecraft:log", "minecraft:log", 64, axis, axes);
        this.woodType = woodType;
        this.stripped = stripped;
        this.allFacesCovered = allFacesCovered;
    }

    @Override
    public int getNumericalId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? 162 : 17;
    }

    @Override
    public String getOldStringId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? "minecraft:log2" : "minecraft:log";
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + (this.stripped ? "stripped_" : "") + this.getWoodType().name().toLowerCase() + (this.allFacesCovered ? "_wood" : "_log");
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        this.woodType = woodType;
    }

    @Override
    public boolean isStripped() {
        return this.stripped;
    }

    @Override
    public void setStripped(boolean stripped) {
        this.stripped = stripped;
    }

    @Override
    public boolean hasAllFacesCovered() {
        return this.allFacesCovered;
    }

    @Override
    public void setAllFacesCovered(boolean allFacesCovered) {
        this.allFacesCovered = allFacesCovered;
    }

    @Override
    public SpongeBlockTypeLog clone() {
        return new SpongeBlockTypeLog(this.getAxis(), this.getAxes(), this.woodType, this.stripped, this.allFacesCovered);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        itemStack.offer(Keys.LOG_AXIS, (Object)(this.allFacesCovered ? LogAxes.NONE : (LogAxis)Sponge.getRegistry().getType(LogAxis.class, this.getAxis().name()).orElseThrow(NullPointerException::new)));
        itemStack.offer(Keys.TREE_TYPE, Sponge.getRegistry().getType(TreeType.class, this.woodType.name()).orElseThrow(NullPointerException::new));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = blockState.with(Keys.LOG_AXIS, (Object)(this.allFacesCovered ? LogAxes.NONE : (LogAxis)Sponge.getRegistry().getType(LogAxis.class, this.getAxis().name()).orElseThrow(NullPointerException::new))).orElse(blockState);
        return blockState.with(Keys.TREE_TYPE, Sponge.getRegistry().getType(TreeType.class, this.woodType.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeLog readContainer(ValueContainer<?> valueContainer) {
        this.woodType = EnumWoodType.getByName(valueContainer.get(Keys.TREE_TYPE).orElse(TreeTypes.OAK).getName()).orElseThrow(NullPointerException::new);
        LogAxis axis = valueContainer.get(Keys.LOG_AXIS).orElse(LogAxes.NONE);
        if (axis.getName().equals(LogAxes.NONE.getName())) {
            this.allFacesCovered = true;
            this.setAxis(EnumAxis.Y);
        } else {
            this.allFacesCovered = false;
            this.setAxis(EnumAxis.valueOf(axis.getName()));
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeLog that = (SpongeBlockTypeLog)o;
        return this.stripped == that.stripped && this.allFacesCovered == that.allFacesCovered && this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.woodType, this.stripped, this.allFacesCovered});
    }
}

