/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpongeBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeGate;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeGate
extends SpongeBlockTypeDirectional
implements WSBlockTypeGate {
    private boolean inWall;
    private boolean open;
    private boolean powered;

    public SpongeBlockTypeGate(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, boolean inWall, boolean open, boolean powered) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        this.inWall = inWall;
        this.open = open;
        this.powered = powered;
    }

    @Override
    public boolean isInWall() {
        return this.inWall;
    }

    @Override
    public void setInWall(boolean inWall) {
        this.inWall = inWall;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public SpongeBlockTypeGate clone() {
        return new SpongeBlockTypeGate(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.inWall, this.open, this.powered);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.IN_WALL, (Object)this.inWall);
        itemStack.offer(Keys.OPEN, (Object)this.open);
        itemStack.offer(Keys.POWERED, (Object)this.powered);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        blockState = blockState.with(Keys.IN_WALL, (Object)this.inWall).orElse(blockState);
        blockState = blockState.with(Keys.OPEN, (Object)this.open).orElse(blockState);
        return blockState.with(Keys.POWERED, (Object)this.powered).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeGate readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.inWall = valueContainer.get(Keys.IN_WALL).orElse(false);
        this.open = valueContainer.get(Keys.OPEN).orElse(false);
        this.powered = valueContainer.get(Keys.POWERED).orElse(false);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeGate that = (SpongeBlockTypeGate)o;
        return this.inWall == that.inWall && this.open == that.open && this.powered == that.powered;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inWall, this.open, this.powered);
    }
}

