/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeFlowerType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeFlower;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeFlower
extends SpongeBlockType
implements WSBlockTypeFlower {
    private EnumBlockTypeFlowerType flowerType;

    public SpongeBlockTypeFlower(EnumBlockTypeFlowerType flowerType) {
        super(37, "minecraft:yellow_flower", "minecraft:dandelion", 64);
        Validate.notNull((Object)flowerType, "Flower type cannot be null!");
        this.flowerType = flowerType;
    }

    @Override
    public int getNumericalId() {
        return this.flowerType == EnumBlockTypeFlowerType.DANDELION ? 37 : 38;
    }

    @Override
    public String getOldStringId() {
        return this.flowerType == EnumBlockTypeFlowerType.DANDELION ? "minecraft:yellow_flower" : "minecraft:red_flower";
    }

    @Override
    public String getNewStringId() {
        switch (this.flowerType) {
            case ALLIUM: {
                return "minecraft:allium";
            }
            case HOUSTONIA: {
                return "minecraft:azure_bluet";
            }
            case BLUE_ORCHID: {
                return "minecraft:blue_orchid";
            }
            case OXEYE_DAISY: {
                return "minecraft:oxeye_daisy";
            }
            case RED_TULIP: {
                return "minecraft:red_tulip";
            }
            case PINK_TULIP: {
                return "minecraft:pink_tulip";
            }
            case WHITE_TULIP: {
                return "minecraft:white_tulip";
            }
            case ORANGE_TULIP: {
                return "minecraft:orange_tulip";
            }
            case POPPY: {
                return "minecraft:poppy";
            }
        }
        return "minecraft:dandelion";
    }

    @Override
    public EnumBlockTypeFlowerType getFlowerType() {
        return this.flowerType;
    }

    @Override
    public void setFlowerType(EnumBlockTypeFlowerType flowerType) {
        Validate.notNull((Object)flowerType, "Flower type cannot be null!");
        this.flowerType = flowerType;
    }

    @Override
    public SpongeBlockTypeFlower clone() {
        return new SpongeBlockTypeFlower(this.flowerType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        return super.writeItemStack(itemStack);
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        if (Block.func_149682_b((Block)((IBlockState)blockState).func_177230_c()) == 37) {
            return blockState;
        }
        return (BlockState)((IBlockState)blockState).func_177230_c().func_176203_a(this.flowerType.getValue());
    }

    @Override
    public SpongeBlockTypeFlower readContainer(ValueContainer<?> valueContainer) {
        if (!(valueContainer instanceof IBlockState)) {
            return this;
        }
        IBlockState iBlockState = (IBlockState)valueContainer;
        this.flowerType = Block.func_149682_b((Block)iBlockState.func_177230_c()) == 37 ? EnumBlockTypeFlowerType.DANDELION : EnumBlockTypeFlowerType.getByValue(iBlockState.func_177230_c().func_176201_c(iBlockState)).orElse(EnumBlockTypeFlowerType.POPPY);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeFlower that = (SpongeBlockTypeFlower)o;
        return this.flowerType == that.flowerType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.flowerType});
    }
}

