/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeFarmland;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeFarmland
extends SpongeBlockType
implements WSBlockTypeFarmland {
    private int moisture;
    private int maximumMoisture;

    public SpongeBlockTypeFarmland(int moisture, int maximumMoisture) {
        super(60, "minecraft:farmland", "minecraft:farmland", 64);
        this.moisture = moisture;
        this.maximumMoisture = maximumMoisture;
    }

    @Override
    public int getMoisture() {
        return this.moisture;
    }

    @Override
    public void setMoisture(int moisture) {
        this.moisture = moisture;
    }

    @Override
    public int getMaximumMoisture() {
        return this.maximumMoisture;
    }

    @Override
    public SpongeBlockTypeFarmland clone() {
        return new SpongeBlockTypeFarmland(this.moisture, this.maximumMoisture);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.MOISTURE, (Object)this.moisture);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.MOISTURE, (Object)this.moisture).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeFarmland readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.moisture = valueContainer.get(Keys.MOISTURE).orElse(0);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeFarmland that = (SpongeBlockTypeFarmland)o;
        return this.moisture == that.moisture && this.maximumMoisture == that.maximumMoisture;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.moisture, this.maximumMoisture);
    }
}

