/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeBisectedHalf;
import com.degoos.wetsponge.enums.block.EnumBlockTypeDoorHinge;
import com.degoos.wetsponge.material.block.SpongeBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDoor;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.Hinges;
import org.spongepowered.api.data.type.PortionTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeDoor
extends SpongeBlockTypeDirectional
implements WSBlockTypeDoor {
    private EnumBlockTypeDoorHinge hinge;
    private EnumBlockTypeBisectedHalf half;
    private boolean open;
    private boolean powered;

    public SpongeBlockTypeDoor(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeDoorHinge hinge, EnumBlockTypeBisectedHalf half, boolean open, boolean powered) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        Validate.notNull((Object)hinge, "Hinge cannot be null!");
        Validate.notNull((Object)half, "Half cannot be null!");
        this.hinge = hinge;
        this.half = half;
        this.open = open;
        this.powered = powered;
    }

    @Override
    public EnumBlockTypeDoorHinge getHinge() {
        return this.hinge;
    }

    @Override
    public void setHinge(EnumBlockTypeDoorHinge hinge) {
        Validate.notNull((Object)hinge, "Hinge cannot be null!");
        this.hinge = hinge;
    }

    @Override
    public EnumBlockTypeBisectedHalf getHalf() {
        return this.half;
    }

    @Override
    public void setHalf(EnumBlockTypeBisectedHalf half) {
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public SpongeBlockTypeDoor clone() {
        return new SpongeBlockTypeDoor(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.hinge, this.half, this.open, this.powered);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.HINGE_POSITION, (Object)(this.hinge == EnumBlockTypeDoorHinge.LEFT ? Hinges.LEFT : Hinges.RIGHT));
        itemStack.offer(Keys.OPEN, (Object)this.open);
        itemStack.offer(Keys.PORTION_TYPE, (Object)(this.half == EnumBlockTypeBisectedHalf.TOP ? PortionTypes.TOP : PortionTypes.BOTTOM));
        itemStack.offer(Keys.POWERED, (Object)this.powered);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        blockState = blockState.with(Keys.HINGE_POSITION, (Object)(this.hinge == EnumBlockTypeDoorHinge.LEFT ? Hinges.LEFT : Hinges.RIGHT)).orElse(blockState);
        blockState = blockState.with(Keys.OPEN, (Object)this.open).orElse(blockState);
        blockState = blockState.with(Keys.PORTION_TYPE, (Object)(this.half == EnumBlockTypeBisectedHalf.TOP ? PortionTypes.TOP : PortionTypes.BOTTOM)).orElse(blockState);
        return blockState.with(Keys.POWERED, (Object)this.powered).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeDoor readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.hinge = valueContainer.get(Keys.HINGE_POSITION).orElse(Hinges.LEFT).equals(Hinges.LEFT) ? EnumBlockTypeDoorHinge.LEFT : EnumBlockTypeDoorHinge.RIGHT;
        this.open = valueContainer.get(Keys.OPEN).orElse(false);
        this.half = valueContainer.get(Keys.PORTION_TYPE).orElse(PortionTypes.BOTTOM).equals(PortionTypes.BOTTOM) ? EnumBlockTypeBisectedHalf.BOTTOM : EnumBlockTypeBisectedHalf.TOP;
        this.powered = valueContainer.get(Keys.POWERED).orElse(false);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeDoor that = (SpongeBlockTypeDoor)o;
        return this.open == that.open && this.powered == that.powered && this.hinge == that.hinge && this.half == that.half;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.hinge, this.half, this.open, this.powered});
    }
}

