/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeDirtType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDirt;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DirtType;
import org.spongepowered.api.data.type.DirtTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeDirt
extends SpongeBlockType
implements WSBlockTypeDirt {
    private EnumBlockTypeDirtType dirtType;

    public SpongeBlockTypeDirt(EnumBlockTypeDirtType dirtType) {
        super(3, "minecraft:dirt", "minecraft:dirt", 64);
        Validate.notNull((Object)dirtType, "Dirt type cannot be null!");
        this.dirtType = dirtType;
    }

    @Override
    public String getNewStringId() {
        switch (this.dirtType) {
            case PODZOL: {
                return "minecraft:podzol";
            }
            case COARSE_DIRT: {
                return "minecraft:coarse_dirt";
            }
        }
        return "minecraft:dirt";
    }

    @Override
    public EnumBlockTypeDirtType getDirtType() {
        return this.dirtType;
    }

    @Override
    public void setDirtType(EnumBlockTypeDirtType dirtType) {
        Validate.notNull((Object)dirtType, "Dirt type cannot be null!");
        this.dirtType = dirtType;
    }

    @Override
    public SpongeBlockTypeDirt clone() {
        return new SpongeBlockTypeDirt(this.dirtType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.DIRT_TYPE, (Object)Sponge.getRegistry().getType(DirtType.class, this.dirtType.name()).orElse(DirtTypes.DIRT));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.DIRT_TYPE, (Object)Sponge.getRegistry().getType(DirtType.class, this.dirtType.name()).orElse(DirtTypes.DIRT)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeDirt readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.dirtType = EnumBlockTypeDirtType.getByName(((DirtType)valueContainer.get(Keys.DIRT_TYPE).get()).getName()).orElse(EnumBlockTypeDirtType.DIRT);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeDirt that = (SpongeBlockTypeDirt)o;
        return this.dirtType == that.dirtType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.dirtType});
    }
}

