/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeCake;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeCake
extends SpongeBlockType
implements WSBlockTypeCake {
    private int bites;
    private int maximumBites;

    public SpongeBlockTypeCake(int bites, int maximumBites) {
        super(92, "minecraft:cake", "minecraft:cake", 64);
        this.bites = bites;
        this.maximumBites = maximumBites;
    }

    @Override
    public int getBites() {
        return this.bites;
    }

    @Override
    public void setBites(int bites) {
        this.bites = Math.min(this.maximumBites, Math.max(0, bites));
    }

    @Override
    public int getMaximumBites() {
        return this.maximumBites;
    }

    @Override
    public SpongeBlockTypeCake clone() {
        return new SpongeBlockTypeCake(this.bites, this.maximumBites);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.LAYER, (Object)this.bites);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.LAYER, (Object)this.bites).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeCake readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.bites = valueContainer.get(Keys.LAYER).orElse(0);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeCake that = (SpongeBlockTypeCake)o;
        return this.bites == that.bites && this.maximumBites == that.maximumBites;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bites, this.maximumBites);
    }
}

