/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.EnumDyeColor;
import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeBedPart;
import com.degoos.wetsponge.material.block.SpongeBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeBed;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeBed
extends SpongeBlockTypeDirectional
implements WSBlockTypeBed {
    private EnumBlockTypeBedPart bedPart;
    private boolean occupied;
    private EnumDyeColor dyeColor;

    public SpongeBlockTypeBed(EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeBedPart bedPart, boolean occupied, EnumDyeColor dyeColor) {
        super(26, "minecraft:bed", "bed", 1, facing, faces);
        Validate.notNull((Object)bedPart, "Bed part cannot be null!");
        Validate.notNull((Object)dyeColor, "Dye color cannot be null!");
        this.bedPart = bedPart;
        this.occupied = occupied;
        this.dyeColor = dyeColor;
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + this.dyeColor.getMinecraftName().toLowerCase() + "_" + super.getNewStringId();
    }

    @Override
    public EnumBlockTypeBedPart getPart() {
        return this.bedPart;
    }

    @Override
    public void setPart(EnumBlockTypeBedPart part) {
        Validate.notNull((Object)part, "Bed part cannot be null!");
        this.bedPart = part;
    }

    @Override
    public boolean isOccupied() {
        return this.occupied;
    }

    @Override
    public EnumDyeColor getDyeColor() {
        return this.dyeColor;
    }

    @Override
    public void setDyeColor(EnumDyeColor dyeColor) {
        Validate.notNull((Object)dyeColor, "Dye color cannot be null!");
        this.dyeColor = dyeColor;
    }

    @Override
    public SpongeBlockTypeBed clone() {
        return new SpongeBlockTypeBed(this.getFacing(), this.getFaces(), this.bedPart, this.occupied, this.dyeColor);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.OCCUPIED, (Object)this.occupied);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.OCCUPIED, (Object)this.occupied).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeBed readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.occupied = valueContainer.get(Keys.OCCUPIED).orElse(false);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeBed that = (SpongeBlockTypeBed)o;
        return this.occupied == that.occupied && this.bedPart == that.bedPart && this.dyeColor == that.dyeColor;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.bedPart, this.occupied, this.dyeColor});
    }
}

