/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeBisectedHalf;
import com.degoos.wetsponge.material.block.SpigotBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeTrapDoor;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;
import org.bukkit.material.TrapDoor;

public class SpigotBlockTypeTrapDoor
extends SpigotBlockTypeDirectional
implements WSBlockTypeTrapDoor {
    private EnumBlockTypeBisectedHalf half;
    private boolean open;
    private boolean powered;
    private boolean waterlogged;

    public SpigotBlockTypeTrapDoor(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeBisectedHalf half, boolean open, boolean powered, boolean waterlogged) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
        this.open = open;
        this.powered = powered;
        this.waterlogged = waterlogged;
    }

    @Override
    public EnumBlockTypeBisectedHalf getHalf() {
        return this.half;
    }

    @Override
    public void setHalf(EnumBlockTypeBisectedHalf half) {
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    @Override
    public void setWaterlogged(boolean waterlogged) {
        this.waterlogged = waterlogged;
    }

    @Override
    public SpigotBlockTypeTrapDoor clone() {
        return new SpigotBlockTypeTrapDoor(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.half, this.open, this.powered, this.waterlogged);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof TrapDoor) {
            ((TrapDoor)data).setInverted(this.half == EnumBlockTypeBisectedHalf.TOP);
            ((TrapDoor)data).setOpen(this.open);
        }
        return data;
    }

    @Override
    public SpigotBlockTypeTrapDoor readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        if (materialData instanceof TrapDoor) {
            this.half = ((TrapDoor)materialData).isInverted() ? EnumBlockTypeBisectedHalf.TOP : EnumBlockTypeBisectedHalf.BOTTOM;
            this.open = ((TrapDoor)materialData).isOpen();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeTrapDoor that = (SpigotBlockTypeTrapDoor)o;
        return this.open == that.open && this.powered == that.powered && this.waterlogged == that.waterlogged && this.half == that.half;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.half, this.open, this.powered, this.waterlogged});
    }
}

