/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSnow;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeSnow
extends SpigotBlockType
implements WSBlockTypeSnow {
    private int layers;
    private int minimumLayers;
    private int maximumLayers;

    public SpigotBlockTypeSnow(int layers, int minimumLayers, int maximumLayers) {
        super(78, "minecraft:snow_layer", "minecraft:snow", 64);
        this.layers = layers;
        this.minimumLayers = minimumLayers;
        this.maximumLayers = maximumLayers;
    }

    @Override
    public int getLayers() {
        return this.layers;
    }

    @Override
    public void setLayers(int layers) {
        layers = Math.max(this.minimumLayers, Math.min(this.maximumLayers, layers));
    }

    @Override
    public int getMinimumLayers() {
        return this.minimumLayers;
    }

    @Override
    public int getMaximumLayers() {
        return this.maximumLayers;
    }

    @Override
    public SpigotBlockTypeSnow clone() {
        return new SpigotBlockTypeSnow(this.layers, this.minimumLayers, this.maximumLayers);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)Math.max(0, this.layers - 1));
        return data;
    }

    @Override
    public SpigotBlockTypeSnow readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.layers = materialData.getData() + 1;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeSnow that = (SpigotBlockTypeSnow)o;
        return this.layers == that.layers && this.minimumLayers == that.minimumLayers && this.maximumLayers == that.maximumLayers;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.layers, this.minimumLayers, this.maximumLayers);
    }
}

