/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSandType;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSand;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeSand
extends SpigotBlockType
implements WSBlockTypeSand {
    private EnumBlockTypeSandType sandType;

    public SpigotBlockTypeSand(EnumBlockTypeSandType sandType) {
        super(12, "minecraft:sand", "minecraft:sand", 64);
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        this.sandType = sandType;
    }

    @Override
    public String getNewStringId() {
        return this.sandType == EnumBlockTypeSandType.NORMAL ? "minecraft:sand" : "minecraft:red_sand";
    }

    @Override
    public EnumBlockTypeSandType getSandType() {
        return this.sandType;
    }

    @Override
    public void setSandType(EnumBlockTypeSandType sandType) {
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        this.sandType = sandType;
    }

    @Override
    public SpigotBlockTypeSand clone() {
        return new SpigotBlockTypeSand(this.sandType);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData materialData = super.toMaterialData();
        materialData.setData((byte)this.sandType.getValue());
        return materialData;
    }

    @Override
    public SpigotBlockTypeSand readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.sandType = EnumBlockTypeSandType.getByValue(materialData.getData()).orElse(EnumBlockTypeSandType.NORMAL);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeSand that = (SpigotBlockTypeSand)o;
        return this.sandType == that.sandType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sandType});
    }
}

