/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumAxis;
import com.degoos.wetsponge.enums.block.EnumBlockTypeQuartzType;
import com.degoos.wetsponge.material.block.SpigotBlockTypeOrientable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeQuartz;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeQuartz
extends SpigotBlockTypeOrientable
implements WSBlockTypeQuartz {
    private EnumBlockTypeQuartzType quartzType;

    public SpigotBlockTypeQuartz(EnumAxis axis, Set<EnumAxis> axes, EnumBlockTypeQuartzType quartzType) {
        super(155, "minecraft:quartz_block", "minecraft:quartz_block", 64, axis, axes);
        Validate.notNull((Object)quartzType, "Quartz type cannot be null!");
        this.quartzType = quartzType;
    }

    @Override
    public String getNewStringId() {
        switch (this.quartzType) {
            case CHISELED: {
                return "minecraft:chiseled_quartz_block";
            }
            case PILLAR: {
                return "minecraft:quartz_pillar";
            }
        }
        return "minecraft:quartz_block";
    }

    @Override
    public EnumBlockTypeQuartzType getQuartzType() {
        return this.quartzType;
    }

    @Override
    public void setQuartzType(EnumBlockTypeQuartzType quartzType) {
        Validate.notNull((Object)quartzType, "Quartz type cannot be null!");
        this.quartzType = quartzType;
    }

    @Override
    public SpigotBlockTypeQuartz clone() {
        return new SpigotBlockTypeQuartz(this.getAxis(), this.getAxes(), this.quartzType);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (this.quartzType == EnumBlockTypeQuartzType.NORMAL) {
            data.setData((byte)0);
        } else {
            switch (this.getAxis()) {
                case X: {
                    data.setData((byte)(4 + this.quartzType.getValue()));
                    break;
                }
                case Z: {
                    data.setData((byte)(8 + this.quartzType.getValue()));
                    break;
                }
                default: {
                    data.setData((byte)this.quartzType.getValue());
                }
            }
        }
        return data;
    }

    @Override
    public SpigotBlockTypeQuartz readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        byte data = materialData.getData();
        this.quartzType = EnumBlockTypeQuartzType.getByValue(data % 4).orElse(EnumBlockTypeQuartzType.NORMAL);
        switch (data / 4) {
            case 1: {
                this.setAxis(EnumAxis.X);
                break;
            }
            case 2: {
                this.setAxis(EnumAxis.Z);
                break;
            }
            case 0: {
                this.setAxis(EnumAxis.Y);
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeQuartz that = (SpigotBlockTypeQuartz)o;
        return this.quartzType == that.quartzType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.quartzType});
    }
}

