/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.EnumInstrument;
import com.degoos.wetsponge.material.block.SpigotBlockTypePowerable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeNoteBlock;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeNoteBlock
extends SpigotBlockTypePowerable
implements WSBlockTypeNoteBlock {
    private EnumInstrument instrument;
    private int note;

    public SpigotBlockTypeNoteBlock(boolean powered, EnumInstrument instrument, int note) {
        super(25, "minecraft:noteblock", "minecraft:note_block", 64, powered);
        Validate.notNull((Object)instrument, "Instrument cannot be null!");
        this.instrument = instrument;
        this.note = Math.max(0, Math.min(25, note));
    }

    @Override
    public EnumInstrument getInstrument() {
        return this.instrument;
    }

    @Override
    public void setInstrument(EnumInstrument instrument) {
        Validate.notNull((Object)instrument, "Instrument cannot be null!");
        this.instrument = instrument;
    }

    @Override
    public int getNote() {
        return this.note;
    }

    @Override
    public void setNote(int note) {
        this.note = Math.max(0, Math.min(25, note));
    }

    @Override
    public SpigotBlockTypeNoteBlock clone() {
        return new SpigotBlockTypeNoteBlock(this.isPowered(), this.instrument, this.note);
    }

    @Override
    public MaterialData toMaterialData() {
        return super.toMaterialData();
    }

    @Override
    public SpigotBlockTypeNoteBlock readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeNoteBlock that = (SpigotBlockTypeNoteBlock)o;
        return this.note == that.note && this.instrument == that.instrument;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.instrument, this.note});
    }
}

