/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumAxis;
import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.SpigotBlockTypeOrientable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeLog;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeLog
extends SpigotBlockTypeOrientable
implements WSBlockTypeLog {
    private EnumWoodType woodType;
    private boolean stripped;
    private boolean allFacesCovered;

    public SpigotBlockTypeLog(EnumAxis axis, Set<EnumAxis> axes, EnumWoodType woodType, boolean stripped, boolean allFacesCovered) {
        super(17, "minecraft:log", "minecraft:log", 64, axis, axes);
        this.woodType = woodType;
        this.stripped = stripped;
        this.allFacesCovered = allFacesCovered;
    }

    @Override
    public int getNumericalId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? 162 : 17;
    }

    @Override
    public String getOldStringId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? "minecraft:log2" : "minecraft:log";
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + (this.stripped ? "stripped_" : "") + this.getWoodType().name().toLowerCase() + (this.allFacesCovered ? "_wood" : "_log");
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        this.woodType = woodType;
    }

    @Override
    public boolean isStripped() {
        return this.stripped;
    }

    @Override
    public void setStripped(boolean stripped) {
        this.stripped = stripped;
    }

    @Override
    public boolean hasAllFacesCovered() {
        return this.allFacesCovered;
    }

    @Override
    public void setAllFacesCovered(boolean allFacesCovered) {
        this.allFacesCovered = allFacesCovered;
    }

    @Override
    public SpigotBlockTypeLog clone() {
        return new SpigotBlockTypeLog(this.getAxis(), this.getAxes(), this.woodType, this.stripped, this.allFacesCovered);
    }

    @Override
    public MaterialData toMaterialData() {
        int sum;
        MaterialData data = super.toMaterialData();
        if (this.allFacesCovered) {
            sum = 12;
        } else {
            switch (this.getAxis()) {
                case X: {
                    sum = 4;
                    break;
                }
                case Z: {
                    sum = 8;
                    break;
                }
                default: {
                    sum = 0;
                }
            }
        }
        data.setData((byte)(sum + this.woodType.getValue() % 4));
        return data;
    }

    @Override
    public SpigotBlockTypeLog readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        byte data = materialData.getData();
        switch (data / 4) {
            case 1: {
                this.setAxis(EnumAxis.X);
                this.allFacesCovered = false;
                break;
            }
            case 2: {
                this.setAxis(EnumAxis.Z);
                this.allFacesCovered = false;
                break;
            }
            case 3: {
                this.setAxis(EnumAxis.Y);
                this.allFacesCovered = true;
                break;
            }
            default: {
                this.setAxis(EnumAxis.Y);
                this.allFacesCovered = false;
            }
        }
        this.woodType = this.getNumericalId() == 17 ? EnumWoodType.getByValue(data % 4).orElse(EnumWoodType.OAK) : EnumWoodType.getByValue(data % 4 + 4).orElse(EnumWoodType.OAK);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeLog that = (SpigotBlockTypeLog)o;
        return this.stripped == that.stripped && this.allFacesCovered == that.allFacesCovered && this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.woodType, this.stripped, this.allFacesCovered});
    }
}

