/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpigotBlockTypeMultipleFacing;
import com.degoos.wetsponge.material.block.type.WSBlockTypeFire;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeFire
extends SpigotBlockTypeMultipleFacing
implements WSBlockTypeFire {
    private int age;
    private int maximumAge;

    public SpigotBlockTypeFire(Set<EnumBlockFace> faces, Set<EnumBlockFace> allowedFaces, int age, int maximumAge) {
        super(51, "minecraft:fire", "minecraft:fire", 64, faces, allowedFaces);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public SpigotBlockTypeFire clone() {
        return new SpigotBlockTypeFire(this.getFaces(), this.getAllowedFaces(), this.age, this.maximumAge);
    }

    @Override
    public MaterialData toMaterialData() {
        return super.toMaterialData();
    }

    @Override
    public SpigotBlockTypeFire readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeFire that = (SpigotBlockTypeFire)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

