/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpigotBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeEndPortalFrame;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeEndPortalFrame
extends SpigotBlockTypeDirectional
implements WSBlockTypeEndPortalFrame {
    private boolean eye;

    public SpigotBlockTypeEndPortalFrame(EnumBlockFace facing, Set<EnumBlockFace> faces, boolean eye) {
        super(120, "minecraft:end_portal_frame", "minecraft:end_portal_frame", 64, facing, faces);
        this.eye = eye;
    }

    @Override
    public boolean hasEye() {
        return this.eye;
    }

    @Override
    public void setEye(boolean eye) {
        this.eye = eye;
    }

    @Override
    public SpigotBlockTypeEndPortalFrame clone() {
        return new SpigotBlockTypeEndPortalFrame(this.getFacing(), this.getFaces(), this.eye);
    }

    @Override
    public MaterialData toMaterialData() {
        int data;
        MaterialData materialData = super.toMaterialData();
        switch (this.getFacing()) {
            case EAST: {
                data = 1;
                break;
            }
            case SOUTH: {
                data = 2;
                break;
            }
            case WEST: {
                data = 3;
                break;
            }
            default: {
                data = 0;
            }
        }
        materialData.setData((byte)(data + (this.eye ? 4 : 0)));
        return materialData;
    }

    @Override
    public SpigotBlockTypeEndPortalFrame readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        byte data = materialData.getData();
        this.eye = data > 3;
        switch (data % 4) {
            case 1: {
                this.setFacing(EnumBlockFace.EAST);
                break;
            }
            case 2: {
                this.setFacing(EnumBlockFace.SOUTH);
                break;
            }
            case 3: {
                this.setFacing(EnumBlockFace.WEST);
                break;
            }
            default: {
                this.setFacing(EnumBlockFace.NORTH);
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeEndPortalFrame that = (SpigotBlockTypeEndPortalFrame)o;
        return this.eye == that.eye;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.eye);
    }
}

