/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeBisectedHalf;
import com.degoos.wetsponge.enums.block.EnumBlockTypeDoorHinge;
import com.degoos.wetsponge.material.block.SpigotBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDoor;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeDoor
extends SpigotBlockTypeDirectional
implements WSBlockTypeDoor {
    private EnumBlockTypeDoorHinge hinge;
    private EnumBlockTypeBisectedHalf half;
    private boolean open;
    private boolean powered;

    public SpigotBlockTypeDoor(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeDoorHinge hinge, EnumBlockTypeBisectedHalf half, boolean open, boolean powered) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        Validate.notNull((Object)hinge, "Hinge cannot be null!");
        Validate.notNull((Object)half, "Half cannot be null!");
        this.hinge = hinge;
        this.half = half;
        this.open = open;
        this.powered = powered;
    }

    @Override
    public EnumBlockTypeDoorHinge getHinge() {
        return this.hinge;
    }

    @Override
    public void setHinge(EnumBlockTypeDoorHinge hinge) {
        Validate.notNull((Object)hinge, "Hinge cannot be null!");
        this.hinge = hinge;
    }

    @Override
    public EnumBlockTypeBisectedHalf getHalf() {
        return this.half;
    }

    @Override
    public void setHalf(EnumBlockTypeBisectedHalf half) {
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public SpigotBlockTypeDoor clone() {
        return new SpigotBlockTypeDoor(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.hinge, this.half, this.open, this.powered);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof Door) {
            ((Door)data).setOpen(this.open);
            ((Door)data).setHinge(this.hinge == EnumBlockTypeDoorHinge.RIGHT);
            ((Door)data).setTopHalf(this.half == EnumBlockTypeBisectedHalf.TOP);
        }
        return data;
    }

    @Override
    public SpigotBlockTypeDirectional readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        if (materialData instanceof Door) {
            this.half = ((Door)materialData).isTopHalf() ? EnumBlockTypeBisectedHalf.TOP : EnumBlockTypeBisectedHalf.BOTTOM;
            this.hinge = ((Door)materialData).getHinge() ? EnumBlockTypeDoorHinge.RIGHT : EnumBlockTypeDoorHinge.LEFT;
            this.open = ((Door)materialData).isOpen();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeDoor that = (SpigotBlockTypeDoor)o;
        return this.open == that.open && this.powered == that.powered && this.hinge == that.hinge && this.half == that.half;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.hinge, this.half, this.open, this.powered});
    }
}

