/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeCake;
import java.util.Objects;
import org.bukkit.material.Cake;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeCake
extends SpigotBlockType
implements WSBlockTypeCake {
    private int bites;
    private int maximumBites;

    public SpigotBlockTypeCake(int bites, int maximumBites) {
        super(92, "minecraft:cake", "minecraft:cake", 64);
        this.bites = bites;
        this.maximumBites = maximumBites;
    }

    @Override
    public int getBites() {
        return this.bites;
    }

    @Override
    public void setBites(int bites) {
        this.bites = Math.min(this.maximumBites, Math.max(0, bites));
    }

    @Override
    public int getMaximumBites() {
        return this.maximumBites;
    }

    @Override
    public SpigotBlockTypeCake clone() {
        return new SpigotBlockTypeCake(this.bites, this.maximumBites);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof Cake) {
            ((Cake)data).setSlicesEaten(this.bites);
        }
        return data;
    }

    @Override
    public SpigotBlockTypeCake readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        if (materialData instanceof Cake) {
            this.bites = ((Cake)materialData).getSlicesEaten();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeCake that = (SpigotBlockTypeCake)o;
        return this.bites == that.bites && this.maximumBites == that.maximumBites;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bites, this.maximumBites);
    }
}

