/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeAnvilDamage;
import com.degoos.wetsponge.material.block.SpigotBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeAnvil;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeAnvil
extends SpigotBlockTypeDirectional
implements WSBlockTypeAnvil {
    private EnumBlockTypeAnvilDamage damage;

    public SpigotBlockTypeAnvil(EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeAnvilDamage damage) {
        super(145, "minecraft:anvil", "minecraft:anvil", 64, facing, faces);
        Validate.notNull((Object)damage, "Damage cannot be null!");
        this.damage = damage;
    }

    @Override
    public String getNewStringId() {
        switch (this.damage) {
            case DAMAGED: {
                return "minecraft:chipped_anvil";
            }
            case VERY_DAMAGED: {
                return "minecraft:damaged_anvil";
            }
        }
        return "minecraft:anvil";
    }

    @Override
    public EnumBlockTypeAnvilDamage getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(EnumBlockTypeAnvilDamage damage) {
        Validate.notNull((Object)damage, "Damage cannot be null!");
        this.damage = damage;
    }

    @Override
    public SpigotBlockTypeAnvil clone() {
        return new SpigotBlockTypeAnvil(this.getFacing(), this.getFaces(), this.damage);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.damage.getValue());
        return data;
    }

    @Override
    public SpigotBlockTypeAnvil readMaterialData(MaterialData materialData) {
        this.damage = EnumBlockTypeAnvilDamage.getByValue(materialData.getData()).orElse(EnumBlockTypeAnvilDamage.NORMAL);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeAnvil that = (SpigotBlockTypeAnvil)o;
        return this.damage == that.damage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.damage});
    }
}

