/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeTurtleEgg;
import java.util.Objects;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TurtleEgg;

public class Spigot13BlockTypeTurtleEgg
extends Spigot13BlockType
implements WSBlockTypeTurtleEgg {
    private int eggs;
    private int minimumEggs;
    private int maximumEggs;
    private int hatch;
    private int maximumHatch;

    public Spigot13BlockTypeTurtleEgg(int eggs, int minimumEggs, int maximumEggs, int hatch, int maximumHatch) {
        super(-1, null, "minecraft:turtle_egg", 64);
        this.eggs = eggs;
        this.minimumEggs = minimumEggs;
        this.maximumEggs = maximumEggs;
        this.hatch = hatch;
        this.maximumHatch = maximumHatch;
    }

    @Override
    public int getEggs() {
        return this.eggs;
    }

    @Override
    public void setEggs(int eggs) {
        this.eggs = Math.max(this.minimumEggs, Math.min(this.maximumEggs, eggs));
    }

    @Override
    public int getMinimumEggs() {
        return this.minimumEggs;
    }

    @Override
    public int getMaximumEggs() {
        return this.maximumEggs;
    }

    @Override
    public int getHatch() {
        return this.hatch;
    }

    @Override
    public void setHatch(int hatch) {
        this.hatch = Math.max(0, Math.min(this.maximumHatch, hatch));
    }

    @Override
    public int getMaximumHatch() {
        return this.maximumHatch;
    }

    @Override
    public Spigot13BlockTypeTurtleEgg clone() {
        return new Spigot13BlockTypeTurtleEgg(this.eggs, this.minimumEggs, this.maximumEggs, this.hatch, this.maximumHatch);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof TurtleEgg) {
            ((TurtleEgg)blockData).setEggs(this.eggs);
            ((TurtleEgg)blockData).setHatch(this.hatch);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeTurtleEgg readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof TurtleEgg) {
            this.eggs = ((TurtleEgg)blockData).getEggs();
            this.minimumEggs = ((TurtleEgg)blockData).getMinimumEggs();
            this.maximumHatch = ((TurtleEgg)blockData).getMaximumHatch();
            this.hatch = ((TurtleEgg)blockData).getHatch();
            this.maximumHatch = ((TurtleEgg)blockData).getMaximumHatch();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeTurtleEgg that = (Spigot13BlockTypeTurtleEgg)o;
        return this.eggs == that.eggs && this.minimumEggs == that.minimumEggs && this.maximumEggs == that.maximumEggs && this.hatch == that.hatch && this.maximumHatch == that.maximumHatch;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.eggs, this.minimumEggs, this.maximumEggs, this.hatch, this.maximumHatch);
    }
}

