/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeBisectedHalf;
import com.degoos.wetsponge.enums.block.EnumBlockTypeStairShape;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeStairs;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;

public class Spigot13BlockTypeStairs
extends Spigot13BlockTypeDirectional
implements WSBlockTypeStairs {
    private EnumBlockTypeStairShape shape;
    private EnumBlockTypeBisectedHalf half;
    private boolean waterlogged;

    public Spigot13BlockTypeStairs(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeStairShape shape, EnumBlockTypeBisectedHalf half, boolean waterlogged) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        Validate.notNull((Object)shape, "Shape cannot be null!");
        Validate.notNull((Object)half, "Half cannot be null!");
        this.shape = shape;
        this.half = half;
        this.waterlogged = waterlogged;
    }

    @Override
    public EnumBlockTypeStairShape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(EnumBlockTypeStairShape shape) {
        Validate.notNull((Object)shape, "Shape cannot be null!");
        this.shape = shape;
    }

    @Override
    public EnumBlockTypeBisectedHalf getHalf() {
        return this.half;
    }

    @Override
    public void setHalf(EnumBlockTypeBisectedHalf half) {
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    @Override
    public void setWaterlogged(boolean waterlogged) {
        this.waterlogged = waterlogged;
    }

    @Override
    public Spigot13BlockTypeStairs clone() {
        return new Spigot13BlockTypeStairs(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.shape, this.half, this.waterlogged);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Stairs) {
            ((Stairs)blockData).setWaterlogged(this.waterlogged);
            ((Stairs)blockData).setHalf(Bisected.Half.valueOf((String)this.half.name()));
            ((Stairs)blockData).setShape(Stairs.Shape.valueOf((String)this.shape.name()));
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeStairs readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Stairs) {
            this.waterlogged = ((Stairs)blockData).isWaterlogged();
            this.half = EnumBlockTypeBisectedHalf.valueOf(((Stairs)blockData).getHalf().name());
            this.shape = EnumBlockTypeStairShape.valueOf(((Stairs)blockData).getShape().name());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeStairs that = (Spigot13BlockTypeStairs)o;
        return this.waterlogged == that.waterlogged && this.shape == that.shape && this.half == that.half;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.shape, this.half, this.waterlogged});
    }
}

