/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSnow;
import java.util.Objects;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Snow;

public class Spigot13BlockTypeSnow
extends Spigot13BlockType
implements WSBlockTypeSnow {
    private int layers;
    private int minimumLayers;
    private int maximumLayers;

    public Spigot13BlockTypeSnow(int layers, int minimumLayers, int maximumLayers) {
        super(78, "minecraft:snow_layer", "minecraft:snow", 64);
        this.layers = layers;
        this.minimumLayers = minimumLayers;
        this.maximumLayers = maximumLayers;
    }

    @Override
    public int getLayers() {
        return this.layers;
    }

    @Override
    public void setLayers(int layers) {
        layers = Math.max(this.minimumLayers, Math.min(this.maximumLayers, layers));
    }

    @Override
    public int getMinimumLayers() {
        return this.minimumLayers;
    }

    @Override
    public int getMaximumLayers() {
        return this.maximumLayers;
    }

    @Override
    public Spigot13BlockTypeSnow clone() {
        return new Spigot13BlockTypeSnow(this.layers, this.minimumLayers, this.maximumLayers);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Snow) {
            ((Snow)blockData).setLayers(this.layers);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeSnow readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Snow) {
            this.layers = ((Snow)blockData).getLayers();
            this.minimumLayers = ((Snow)blockData).getMinimumLayers();
            this.maximumLayers = ((Snow)blockData).getMaximumLayers();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSnow that = (Spigot13BlockTypeSnow)o;
        return this.layers == that.layers && this.minimumLayers == that.minimumLayers && this.maximumLayers == that.maximumLayers;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.layers, this.minimumLayers, this.maximumLayers);
    }
}

