/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeRotatable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSign;
import java.util.Objects;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sign;

public class Spigot13BlockTypeSign
extends Spigot13BlockTypeRotatable
implements WSBlockTypeSign {
    private boolean waterlogged;

    public Spigot13BlockTypeSign(EnumBlockFace rotation, boolean waterlogged) {
        super(63, "minecraft:standing_sign", "minecraft:sign", 64, rotation);
        this.waterlogged = waterlogged;
    }

    @Override
    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    @Override
    public void setWaterlogged(boolean waterlogged) {
        this.waterlogged = waterlogged;
    }

    @Override
    public Spigot13BlockTypeSign clone() {
        return new Spigot13BlockTypeSign(this.getRotation(), this.waterlogged);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Sign) {
            ((Sign)blockData).setWaterlogged(this.waterlogged);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeSign readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Sign) {
            this.waterlogged = ((Sign)blockData).isWaterlogged();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSign that = (Spigot13BlockTypeSign)o;
        return this.waterlogged == that.waterlogged;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.waterlogged);
    }
}

