/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSandType;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSand;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.block.data.BlockData;

public class Spigot13BlockTypeSand
extends Spigot13BlockType
implements WSBlockTypeSand {
    private EnumBlockTypeSandType sandType;

    public Spigot13BlockTypeSand(EnumBlockTypeSandType sandType) {
        super(12, "minecraft:sand", "minecraft:sand", 64);
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        this.sandType = sandType;
    }

    @Override
    public String getNewStringId() {
        return this.sandType == EnumBlockTypeSandType.NORMAL ? "minecraft:sand" : "minecraft:red_sand";
    }

    @Override
    public EnumBlockTypeSandType getSandType() {
        return this.sandType;
    }

    @Override
    public void setSandType(EnumBlockTypeSandType sandType) {
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        this.sandType = sandType;
    }

    @Override
    public Spigot13BlockTypeSand clone() {
        return new Spigot13BlockTypeSand(this.sandType);
    }

    @Override
    public Spigot13BlockTypeSand readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSand that = (Spigot13BlockTypeSand)o;
        return this.sandType == that.sandType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sandType});
    }
}

