/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeComparatorMode;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeComparator;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Comparator;

public class Spigot13BlockTypeComparator
extends Spigot13BlockTypeDirectional
implements WSBlockTypeComparator {
    private EnumBlockTypeComparatorMode mode;
    private boolean powered;

    public Spigot13BlockTypeComparator(EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeComparatorMode mode, boolean powered) {
        super(149, "minecraft:unpowered_comparator", "minecraft:comparator", 64, facing, faces);
        Validate.notNull((Object)mode, "Mode cannot be null!");
        this.mode = mode;
        this.powered = powered;
    }

    @Override
    public int getNumericalId() {
        return this.isPowered() ? 150 : 149;
    }

    @Override
    public String getOldStringId() {
        return this.isPowered() ? "minecraft:powered_comparator" : "minecraft:unpowered_comparator";
    }

    @Override
    public EnumBlockTypeComparatorMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(EnumBlockTypeComparatorMode mode) {
        Validate.notNull((Object)mode, "Mode cannot be null!");
        this.mode = mode;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public Spigot13BlockTypeComparator clone() {
        return new Spigot13BlockTypeComparator(this.getFacing(), this.getFaces(), this.mode, this.powered);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Comparator) {
            ((Comparator)blockData).setPowered(this.powered);
            ((Comparator)blockData).setMode(Comparator.Mode.valueOf((String)this.mode.name()));
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeDirectional readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Comparator) {
            this.mode = EnumBlockTypeComparatorMode.valueOf(((Comparator)blockData).getMode().name());
            this.powered = ((Comparator)blockData).isPowered();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeComparator that = (Spigot13BlockTypeComparator)o;
        return this.powered == that.powered && this.mode == that.mode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mode, this.powered});
    }
}

