/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeSnowable;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeSnowable
extends SpongeBlockType
implements WSBlockTypeSnowable {
    public boolean snowy;

    public SpongeBlockTypeSnowable(int numericalId, String oldStringId, String newStringId, int maxStackSize, boolean snowy) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.snowy = snowy;
    }

    @Override
    public boolean isSnowy() {
        return this.snowy;
    }

    @Override
    public void setSnowy(boolean snowy) {
        this.snowy = snowy;
    }

    @Override
    public SpongeBlockTypeSnowable clone() {
        return new SpongeBlockTypeSnowable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.snowy);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.SNOWED, (Object)this.snowy);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.SNOWED, (Object)this.snowy).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeSnowable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.snowy = valueContainer.get(Keys.SNOWED).orElse(false);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeSnowable that = (SpongeBlockTypeSnowable)o;
        return this.snowy == that.snowy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.snowy);
    }
}

