/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeRotatable;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Direction;

public class SpongeBlockTypeRotatable
extends SpongeBlockType
implements WSBlockTypeRotatable {
    private EnumBlockFace rotation;

    public SpongeBlockTypeRotatable(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace rotation) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.rotation = rotation;
    }

    @Override
    public EnumBlockFace getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(EnumBlockFace rotation) {
        Validate.notNull((Object)rotation, "Rotation cannot be null!");
        this.rotation = rotation;
    }

    @Override
    public SpongeBlockTypeRotatable clone() {
        return new SpongeBlockTypeRotatable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.rotation);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.DIRECTION, (Object)Direction.valueOf((String)this.rotation.getSpongeName()));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.DIRECTION, (Object)Direction.valueOf((String)this.rotation.getSpongeName())).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeRotatable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.rotation = EnumBlockFace.getBySpongeName(((Direction)valueContainer.get(Keys.DIRECTION).orElseThrow(NullPointerException::new)).name()).orElseThrow(NullPointerException::new);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeRotatable that = (SpongeBlockTypeRotatable)o;
        return this.rotation == that.rotation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.rotation});
    }
}

