/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumAxis;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeOrientable;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Axis;

public class SpongeBlockTypeOrientable
extends SpongeBlockType
implements WSBlockTypeOrientable {
    private EnumAxis axis;
    private Set<EnumAxis> axes;

    public SpongeBlockTypeOrientable(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumAxis axis, Set<EnumAxis> axes) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        Validate.notNull((Object)axis, "Axis cannot be null!");
        this.axis = axis;
        this.axes = axes;
    }

    @Override
    public EnumAxis getAxis() {
        return this.axis;
    }

    @Override
    public void setAxis(EnumAxis axis) {
        Validate.notNull((Object)axis, "Axis cannot be null!");
        this.axis = axis;
    }

    @Override
    public Set<EnumAxis> getAxes() {
        return new HashSet<EnumAxis>(this.axes);
    }

    @Override
    public SpongeBlockTypeOrientable clone() {
        return new SpongeBlockTypeOrientable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.axis, this.axes);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.AXIS, (Object)Axis.valueOf((String)this.axis.name()));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.AXIS, (Object)Axis.valueOf((String)this.axis.name())).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeOrientable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.axis = valueContainer.get(Keys.AXIS).map(target -> EnumAxis.valueOf(target.name())).orElse(EnumAxis.Y);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeOrientable that = (SpongeBlockTypeOrientable)o;
        return this.axis == that.axis && Objects.equals(this.axes, that.axes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.axis, this.axes});
    }
}

