/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.EnumDyeColor;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDyeColored;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeDyeColored
extends SpongeBlockType
implements WSBlockTypeDyeColored {
    private EnumDyeColor dyeColor;

    public SpongeBlockTypeDyeColored(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumDyeColor dyeColor) {
        super(numericalId, oldStringId, newStringId.startsWith("minecraft:") ? newStringId.substring(10) : newStringId, maxStackSize);
        Validate.notNull((Object)dyeColor, "Dye color cannot be null!");
        this.dyeColor = dyeColor;
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + this.dyeColor.getMinecraftName().toLowerCase() + "_" + super.getNewStringId();
    }

    @Override
    public EnumDyeColor getDyeColor() {
        return this.dyeColor;
    }

    @Override
    public void setDyeColor(EnumDyeColor dyeColor) {
        Validate.notNull((Object)dyeColor, "Dye color cannot be null!");
        this.dyeColor = dyeColor;
    }

    @Override
    public SpongeBlockTypeDyeColored clone() {
        return new SpongeBlockTypeDyeColored(this.getNumericalId(), this.getOldStringId(), super.getNewStringId(), this.getMaxStackSize(), this.dyeColor);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.DYE_COLOR, (Object)Sponge.getRegistry().getType(DyeColor.class, this.dyeColor.getName()).orElse(DyeColors.WHITE));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.DYE_COLOR, (Object)Sponge.getRegistry().getType(DyeColor.class, this.dyeColor.getName()).orElse(DyeColors.WHITE)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeDyeColored readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.dyeColor = EnumDyeColor.getByName(valueContainer.get(Keys.DYE_COLOR).orElse(DyeColors.WHITE).getId()).orElse(EnumDyeColor.WHITE);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeDyeColored that = (SpongeBlockTypeDyeColored)o;
        return this.dyeColor == that.dyeColor;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.dyeColor});
    }
}

