/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockTypeBisectedHalf;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeBisected;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.PortionTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeBisected
extends SpongeBlockType
implements WSBlockTypeBisected {
    private EnumBlockTypeBisectedHalf half;

    public SpongeBlockTypeBisected(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockTypeBisectedHalf half) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public EnumBlockTypeBisectedHalf getHalf() {
        return this.half;
    }

    @Override
    public void setHalf(EnumBlockTypeBisectedHalf half) {
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public SpongeBlockTypeBisected clone() {
        return new SpongeBlockTypeBisected(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.half);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.PORTION_TYPE, (Object)(this.half == EnumBlockTypeBisectedHalf.TOP ? PortionTypes.TOP : PortionTypes.BOTTOM));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.PORTION_TYPE, (Object)(this.half == EnumBlockTypeBisectedHalf.TOP ? PortionTypes.TOP : PortionTypes.BOTTOM)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeBisected readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.half = valueContainer.get(Keys.PORTION_TYPE).orElse(PortionTypes.BOTTOM).equals(PortionTypes.TOP) ? EnumBlockTypeBisectedHalf.TOP : EnumBlockTypeBisectedHalf.BOTTOM;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeBisected that = (SpongeBlockTypeBisected)o;
        return this.half == that.half;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.half});
    }
}

