/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeAttachable;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeAttachable
extends SpongeBlockType
implements WSBlockTypeAttachable {
    private boolean attached;

    public SpongeBlockTypeAttachable(int numericalId, String oldStringId, String newStringId, int maxStackSize, boolean attached) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.attached = attached;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public void setAttached(boolean attached) {
        this.attached = attached;
    }

    @Override
    public SpongeBlockTypeAttachable clone() {
        return new SpongeBlockTypeAttachable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.attached);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.ATTACHED, (Object)this.attached);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.ATTACHED, (Object)this.attached).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeAttachable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.attached = valueContainer.get(Keys.ATTACHED).orElse(false);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeAttachable that = (SpongeBlockTypeAttachable)o;
        return this.attached == that.attached;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.attached);
    }
}

