/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeAnaloguePowerable;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeAnaloguePowerable
extends SpongeBlockType
implements WSBlockTypeAnaloguePowerable {
    private int power;
    private int maximumPower;

    public SpongeBlockTypeAnaloguePowerable(int numericalId, String oldStringId, String newStringId, int maxStackSize, int power, int maximumPower) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.power = power;
        this.maximumPower = maximumPower;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPower(int power) {
        this.power = Math.min(this.maximumPower, Math.max(0, power));
    }

    @Override
    public int gerMaximumPower() {
        return this.maximumPower;
    }

    @Override
    public SpongeBlockTypeAnaloguePowerable clone() {
        return new SpongeBlockTypeAnaloguePowerable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.power, this.maximumPower);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.POWER, (Object)this.power);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.POWER, (Object)this.power).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeAnaloguePowerable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.power = valueContainer.get(Keys.POWER).orElse(0);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeAnaloguePowerable that = (SpongeBlockTypeAnaloguePowerable)o;
        return this.power == that.power && this.maximumPower == that.maximumPower;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.power, this.maximumPower);
    }
}

