/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeWaterlogged;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;

public class Spigot13BlockTypeWaterlogged
extends Spigot13BlockType
implements WSBlockTypeWaterlogged {
    private boolean waterLogged;

    public Spigot13BlockTypeWaterlogged(int numericalId, String oldStringId, String newStringId, int maxStackSize, boolean waterLogged) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.waterLogged = waterLogged;
    }

    @Override
    public boolean isWaterlogged() {
        return this.waterLogged;
    }

    @Override
    public void setWaterlogged(boolean waterlogged) {
        this.waterLogged = waterlogged;
    }

    @Override
    public Spigot13BlockTypeWaterlogged clone() {
        return new Spigot13BlockTypeWaterlogged(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.waterLogged);
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof Waterlogged) {
            ((Waterlogged)data).setWaterlogged(this.waterLogged);
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeWaterlogged readBlockData(BlockData blockData) {
        if (blockData instanceof Waterlogged) {
            this.waterLogged = ((Waterlogged)blockData).isWaterlogged();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeWaterlogged that = (Spigot13BlockTypeWaterlogged)o;
        return this.waterLogged == that.waterLogged;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.waterLogged);
    }
}

