/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypePowerable;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;

public class Spigot13BlockTypePowerable
extends Spigot13BlockType
implements WSBlockTypePowerable {
    private boolean powered;

    public Spigot13BlockTypePowerable(int numericalId, String oldStringId, String newStringId, int maxStackSize, boolean powered) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.powered = powered;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public Spigot13BlockTypePowerable clone() {
        return new Spigot13BlockTypePowerable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.powered);
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof Powerable) {
            ((Powerable)data).setPowered(this.powered);
        }
        return data;
    }

    @Override
    public Spigot13BlockTypePowerable readBlockData(BlockData blockData) {
        if (blockData instanceof Powerable) {
            this.powered = ((Powerable)blockData).isPowered();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypePowerable that = (Spigot13BlockTypePowerable)o;
        return this.powered == that.powered;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.powered);
    }
}

