/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeDirectional;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;

public class Spigot13BlockTypeDirectional
extends Spigot13BlockType
implements WSBlockTypeDirectional {
    private EnumBlockFace facing;
    private Set<EnumBlockFace> faces;

    public Spigot13BlockTypeDirectional(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        Validate.notNull((Object)facing, "Facing cannot be null!");
        this.facing = facing;
        this.faces = faces;
    }

    @Override
    public EnumBlockFace getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumBlockFace blockFace) {
        Validate.notNull((Object)blockFace, "Facing cannot be null!");
        this.facing = blockFace;
    }

    @Override
    public Set<EnumBlockFace> getFaces() {
        return new HashSet<EnumBlockFace>(this.faces);
    }

    @Override
    public Spigot13BlockTypeDirectional clone() {
        return new Spigot13BlockTypeDirectional(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.facing, new HashSet<EnumBlockFace>(this.faces));
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof Directional) {
            ((Directional)data).setFacing(BlockFace.valueOf((String)this.facing.name()));
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeDirectional readBlockData(BlockData blockData) {
        if (blockData instanceof Directional) {
            this.facing = EnumBlockFace.valueOf(((Directional)blockData).getFacing().name());
            this.faces = ((Directional)blockData).getFaces().stream().map(target -> EnumBlockFace.valueOf(target.name())).collect(Collectors.toSet());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeDirectional that = (Spigot13BlockTypeDirectional)o;
        return this.facing == that.facing;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.facing});
    }
}

