/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeAttachable;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.data.BlockData;

public class Spigot13BlockTypeAttachable
extends Spigot13BlockType
implements WSBlockTypeAttachable {
    private boolean attached;

    public Spigot13BlockTypeAttachable(int numericalId, String oldStringId, String newStringId, int maxStackSize, boolean attached) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.attached = attached;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public void setAttached(boolean attached) {
        this.attached = attached;
    }

    @Override
    public Spigot13BlockTypeAttachable clone() {
        return new Spigot13BlockTypeAttachable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.attached);
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof Attachable) {
            ((Attachable)data).setAttached(this.attached);
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeAttachable readBlockData(BlockData blockData) {
        if (blockData instanceof Attachable) {
            this.attached = ((Attachable)blockData).isAttached();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeAttachable that = (Spigot13BlockTypeAttachable)o;
        return this.attached == that.attached;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.attached);
    }
}

