/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block;

import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockTypeAnaloguePowerable;
import com.degoos.wetsponge.util.Spigot13MaterialUtils;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;

public class Spigot13BlockTypeAnaloguePowerable
extends Spigot13BlockType
implements WSBlockTypeAnaloguePowerable {
    private int power;
    private int maximumPower;

    public Spigot13BlockTypeAnaloguePowerable(int numericalId, String oldStringId, String newStringId, int maxStackSize, int power, int maximumPower) {
        super(numericalId, oldStringId, newStringId, maxStackSize);
        this.power = power;
        this.maximumPower = maximumPower;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPower(int power) {
        this.power = Math.min(this.maximumPower, Math.max(0, power));
    }

    @Override
    public int gerMaximumPower() {
        return this.maximumPower;
    }

    @Override
    public Spigot13BlockTypeAnaloguePowerable clone() {
        return new Spigot13BlockTypeAnaloguePowerable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.power, this.maximumPower);
    }

    @Override
    public BlockData toBlockData() {
        Material material = Spigot13MaterialUtils.getByKey(this.getNewStringId()).orElse(null);
        if (material == null) {
            return null;
        }
        BlockData data = material.createBlockData();
        if (data instanceof AnaloguePowerable) {
            ((AnaloguePowerable)data).setPower(this.power);
        }
        return data;
    }

    @Override
    public Spigot13BlockTypeAnaloguePowerable readBlockData(BlockData blockData) {
        if (blockData instanceof AnaloguePowerable) {
            this.power = ((AnaloguePowerable)blockData).getPower();
            this.maximumPower = ((AnaloguePowerable)blockData).getMaximumPower();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeAnaloguePowerable that = (Spigot13BlockTypeAnaloguePowerable)o;
        return this.power == that.power && this.maximumPower == that.maximumPower;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.power, this.maximumPower);
    }
}

