/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.map;

import com.degoos.wetsponge.enums.EnumMapDecorationType;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector2i;

public class WSMapDecoration {
    private Vector2i position;
    private EnumMapDecorationType type;
    private int rotation;

    public WSMapDecoration(Vector2i position, EnumMapDecorationType type, int rotation) {
        Validate.notNull(position, "Position cannot be null!");
        Validate.notNull((Object)type, "Type cannot be null!");
        this.position = position;
        this.type = type;
        this.rotation = rotation;
    }

    public Vector2i getPosition() {
        return this.position;
    }

    public void setPosition(Vector2i position) {
        Validate.notNull(position, "Position cannot be null!");
        this.position = position;
    }

    void setPosition(int x, int z) {
        this.position = new Vector2i(x, z);
    }

    public EnumMapDecorationType getType() {
        return this.type;
    }

    public void setType(EnumMapDecorationType type) {
        Validate.notNull((Object)type, "Type cannot be null!");
        this.type = type;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSMapDecoration that = (WSMapDecoration)o;
        if (this.rotation != that.rotation) {
            return false;
        }
        if (!this.position.equals(that.position)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.rotation;
        return result;
    }
}

