/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.map;

import com.degoos.wetsponge.enums.EnumMapBaseColor;
import com.degoos.wetsponge.enums.EnumMapIllumination;
import com.degoos.wetsponge.util.Validate;
import java.awt.Color;

public class WSMapColor {
    private EnumMapBaseColor baseColor;
    private EnumMapIllumination illumination;

    public WSMapColor(EnumMapBaseColor baseColor, EnumMapIllumination illumination) {
        Validate.notNull((Object)baseColor, "Base cannot be null!");
        this.baseColor = baseColor;
        this.illumination = illumination == null ? EnumMapIllumination.NORMAL : illumination;
    }

    public EnumMapBaseColor getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(EnumMapBaseColor baseColor) {
        Validate.notNull((Object)baseColor, "Base cannot be null!");
        this.baseColor = baseColor;
    }

    public EnumMapIllumination getIllumination() {
        return this.illumination;
    }

    public void setIllumination(EnumMapIllumination illumination) {
        this.illumination = illumination == null ? EnumMapIllumination.NORMAL : illumination;
    }

    public Color getColor() {
        return this.illumination.maskColor(this.baseColor.getColor());
    }

    public byte getMapColor() {
        return this.baseColor == EnumMapBaseColor.AIR ? (byte)0 : (byte)(this.baseColor.getId() * 4 + this.illumination.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSMapColor that = (WSMapColor)o;
        if (this.baseColor != that.baseColor) {
            return false;
        }
        return this.illumination == that.illumination;
    }

    public int hashCode() {
        int result = this.baseColor.hashCode();
        result = 31 * result + this.illumination.hashCode();
        return result;
    }
}

