/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.listener.sponge;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.block.SpongeBlockSnapshot;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumTristate;
import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.event.entity.player.interact.WSPlayerInteractBlockEvent;
import com.degoos.wetsponge.event.entity.player.interact.WSPlayerInteractEntityEvent;
import com.degoos.wetsponge.event.entity.player.interact.WSPlayerInteractEvent;
import com.degoos.wetsponge.event.entity.player.interact.WSPlayerInteractItemEvent;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.world.SpongeLocation;
import com.degoos.wetsponge.world.WSLocation;
import java.util.Optional;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.action.InteractEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.util.Tristate;

public class SpongePlayerInteractListener {
    @Listener(order=Order.FIRST)
    public void onBlockInteraction(InteractEvent event, @First Player spongePlayer) {
        try {
            WSPlayerInteractEvent wetSpongeEvent;
            WSPlayer player = WetSponge.getServer().getPlayer(spongePlayer.getUniqueId()).orElse(null);
            Optional position = event.getInteractionPoint();
            if (event instanceof InteractBlockEvent) {
                Optional<WSLocation> blockLocation = ((InteractBlockEvent)event).getTargetBlock().getLocation().map(SpongeLocation::new);
                SpongeBlockSnapshot block = new SpongeBlockSnapshot(((InteractBlockEvent)event).getTargetBlock());
                EnumBlockFace direction = EnumBlockFace.getBySpongeName(((InteractBlockEvent)event).getTargetSide().name()).orElse(EnumBlockFace.SELF);
                wetSpongeEvent = event instanceof InteractBlockEvent.Primary ? (event instanceof InteractBlockEvent.Primary.MainHand ? new WSPlayerInteractBlockEvent.Primary.MainHand(player, block, direction, position, blockLocation) : new WSPlayerInteractBlockEvent.Primary.OffHand(player, block, direction, position, blockLocation)) : (event instanceof InteractBlockEvent.Secondary.MainHand ? new WSPlayerInteractBlockEvent.Secondary.MainHand(player, block, direction, position, blockLocation, this.transform(((InteractBlockEvent.Secondary)event).getUseBlockResult()), this.transform(((InteractBlockEvent.Secondary)event).getUseItemResult()), this.transform(((InteractBlockEvent.Secondary)event).getOriginalUseBlockResult()), this.transform(((InteractBlockEvent.Secondary)event).getOriginalUseItemResult())) : new WSPlayerInteractBlockEvent.Secondary.OffHand(player, block, direction, position, blockLocation, this.transform(((InteractBlockEvent.Secondary)event).getUseBlockResult()), this.transform(((InteractBlockEvent.Secondary)event).getUseItemResult()), this.transform(((InteractBlockEvent.Secondary)event).getOriginalUseBlockResult()), this.transform(((InteractBlockEvent.Secondary)event).getOriginalUseItemResult())));
                WetSponge.getEventManager().callEvent(wetSpongeEvent);
                if (wetSpongeEvent instanceof WSPlayerInteractBlockEvent.Secondary) {
                    ((InteractBlockEvent.Secondary)event).setUseBlockResult(this.transform(((WSPlayerInteractBlockEvent.Secondary)wetSpongeEvent).getUseBlockResult()));
                    ((InteractBlockEvent.Secondary)event).setUseItemResult(this.transform(((WSPlayerInteractBlockEvent.Secondary)wetSpongeEvent).getUseItemResult()));
                }
            } else if (event instanceof InteractEntityEvent) {
                WSEntity entity = SpongeEntityParser.getWSEntity(((InteractEntityEvent)event).getTargetEntity());
                wetSpongeEvent = event instanceof InteractEntityEvent.Primary ? (event instanceof InteractEntityEvent.Primary.MainHand ? new WSPlayerInteractEntityEvent.Primary.MainHand(player, entity, position) : new WSPlayerInteractEntityEvent.Primary.OffHand(player, entity, position)) : (event instanceof InteractEntityEvent.Secondary.MainHand ? new WSPlayerInteractEntityEvent.Secondary.MainHand(player, entity, position) : new WSPlayerInteractEntityEvent.Secondary.OffHand(player, entity, position));
                WetSponge.getEventManager().callEvent(wetSpongeEvent);
            } else if (event instanceof InteractItemEvent) {
                SpongeItemStack itemStack = new SpongeItemStack(((InteractItemEvent)event).getItemStack().createStack());
                wetSpongeEvent = event instanceof InteractItemEvent.Primary ? (event instanceof InteractItemEvent.Primary.MainHand ? new WSPlayerInteractItemEvent.Primary.MainHand(player, itemStack) : new WSPlayerInteractItemEvent.Primary.OffHand(player, itemStack)) : (event instanceof InteractItemEvent.Secondary.MainHand ? new WSPlayerInteractItemEvent.Secondary.MainHand(player, itemStack) : new WSPlayerInteractItemEvent.Secondary.OffHand(player, itemStack));
                WetSponge.getEventManager().callEvent(wetSpongeEvent);
            } else {
                wetSpongeEvent = new WSPlayerInteractEvent(player);
                WetSponge.getEventManager().callEvent(wetSpongeEvent);
            }
            event.setCancelled(wetSpongeEvent.isCancelled());
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was parsing the event Sponge-InteractEvent!");
        }
    }

    private Tristate transform(EnumTristate result) {
        switch (result) {
            case FALSE: {
                return Tristate.FALSE;
            }
            case TRUE: {
                return Tristate.TRUE;
            }
        }
        return Tristate.UNDEFINED;
    }

    private EnumTristate transform(Tristate result) {
        switch (result) {
            case TRUE: {
                return EnumTristate.TRUE;
            }
            case FALSE: {
                return EnumTristate.FALSE;
            }
        }
        return EnumTristate.UNDEFINED;
    }
}

