/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.listener.spigot;

import com.degoos.wetsponge.SpigotWetSponge;
import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.event.entity.player.movement.WSPlayerChangeWorldEvent;
import com.degoos.wetsponge.event.entity.player.movement.WSPlayerMoveEvent;
import com.degoos.wetsponge.event.entity.player.movement.WSPlayerTeleportEvent;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityLookMove;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.SpigotEventUtils;
import com.degoos.wetsponge.world.SpigotLocation;
import com.degoos.wetsponge.world.WSLocation;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpigotMovementListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onMove(PlayerMoveEvent event) {
        if (!SpigotEventUtils.shouldBeExecuted()) {
            return;
        }
        try {
            WSPlayerMoveEvent wetSpongeEvent = new WSPlayerMoveEvent(PlayerParser.getPlayer(event.getPlayer().getUniqueId()).orElse(null), new SpigotLocation(event.getFrom()), new SpigotLocation(event.getTo()));
            WetSponge.getEventManager().callEvent(wetSpongeEvent);
            event.setCancelled(wetSpongeEvent.isCancelled());
            event.setTo(((SpigotLocation)wetSpongeEvent.getTo()).getLocation());
            wetSpongeEvent.getPlayer().getFakeBlocks().forEach((location, type) -> {
                if (location.distance(wetSpongeEvent.getFrom()) > 100.0 && location.distance(wetSpongeEvent.getTo()) <= 100.0) {
                    wetSpongeEvent.getPlayer().refreshFakeBlock((WSLocation)location);
                }
            });
            if (wetSpongeEvent.getPlayer().hasDisguise()) {
                WSPlayer player = wetSpongeEvent.getPlayer();
                WSLivingEntity entity = wetSpongeEvent.getPlayer().getDisguise().get();
                wetSpongeEvent.getPlayer().sendPacket(WSSPacketEntityLookMove.of(entity.getEntityId(), player.getLocation().toVector3i(), player.getRotation().toVector2().toInt(), player.isOnGround()));
            }
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was parsing the event Spigot-PlayerMoveEvent!");
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (!SpigotEventUtils.shouldBeExecuted()) {
            return;
        }
        try {
            final WSPlayerTeleportEvent wetSpongeEvent = new WSPlayerTeleportEvent(PlayerParser.getPlayer(event.getPlayer().getUniqueId()).orElse(null), new SpigotLocation(event.getFrom()), new SpigotLocation(event.getTo()));
            WetSponge.getEventManager().callEvent(wetSpongeEvent);
            event.setCancelled(wetSpongeEvent.isCancelled());
            event.setTo(((SpigotLocation)wetSpongeEvent.getTo()).getLocation());
            new BukkitRunnable(){

                public void run() {
                    wetSpongeEvent.getPlayer().getFakeBlocks().forEach((location, type) -> {
                        if (location.distance(wetSpongeEvent.getFrom()) > 100.0 && location.distance(wetSpongeEvent.getTo()) <= 100.0) {
                            wetSpongeEvent.getPlayer().refreshFakeBlock((WSLocation)location);
                        }
                    });
                }
            }.runTaskLater((Plugin)SpigotWetSponge.getInstance(), 5L);
            if (wetSpongeEvent.getPlayer() != null && wetSpongeEvent.getPlayer().hasDisguise()) {
                WSPlayer player = wetSpongeEvent.getPlayer();
                WSLivingEntity entity = wetSpongeEvent.getPlayer().getDisguise().get();
                wetSpongeEvent.getPlayer().sendPacket(WSSPacketEntityLookMove.of(entity.getEntityId(), player.getLocation().toVector3i(), player.getRotation().toVector2().toInt(), player.isOnGround()));
            }
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was parsing the event Spigot-PlayerTeleportEvent!");
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        if (!SpigotEventUtils.shouldBeExecuted()) {
            return;
        }
        try {
            final WSPlayer player = PlayerParser.getPlayer(event.getPlayer().getUniqueId()).orElse(null);
            WetSponge.getEventManager().callEvent(new WSPlayerChangeWorldEvent(player, WorldParser.getOrCreateWorld(event.getFrom().getName(), event.getFrom()), WorldParser.getOrCreateWorld(event.getPlayer().getWorld().getName(), event.getPlayer().getWorld())));
            PlayerParser.resetPlayer(event.getPlayer(), event.getPlayer().getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    player.getFakeBlocks().forEach((location, type) -> {
                        if (location.distance(player.getLocation()) <= 100.0) {
                            player.refreshFakeBlock((WSLocation)location);
                        }
                    });
                }
            }.runTaskLater((Plugin)SpigotWetSponge.getInstance(), 5L);
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was parsing the event Spigot-PlayerChangedWorldEvent!");
        }
    }
}

